varying vec3 normal;   // vertex normal in eye space.
varying vec3 position; // vertex position in eye space.
varying vec3 nor;
varying vec3 vertex;
varying vec4 v_position;


uniform float freqX;
uniform float freqY;
uniform float freqZ;
uniform float waveAmpX;
uniform float waveAmpY;
uniform float waveAmpZ;
uniform float waveTime;

void main( void )
{
	//gl_Position = ftransform();
	vec4 vert = gl_Vertex;
	vert.x=vert.x+sin(vert.y*freqX+waveTime)*sin(vert.z*freqX+waveTime)*waveAmpX;
	vert.y=vert.y+sin(vert.x*freqY+waveTime)*sin(vert.z*freqY+waveTime)*waveAmpY;
	vert.z=vert.z+sin(vert.y*freqZ+waveTime)*sin(vert.x*freqZ+waveTime)*waveAmpZ;

 	v_position=(gl_ModelViewProjectionMatrix*vert)/vec4(10);
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_Position = v_position;

	normal = gl_NormalMatrix * gl_Normal;
	nor=gl_Normal;
	position = ( gl_ModelViewMatrix * gl_Vertex ).xyz;
	vertex=gl_Vertex.xyz;
	gl_FrontColor  = gl_Color;

}


